import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.bankId) {
    newObjValue = {...newObjValue, 
      C_Bank_ID: {
        id: body.bankId,
        tableName: 'C_Bank'
      }
    }
  }
  if(body.userId) {
    newObjValue = {...newObjValue, 
      AD_User_ID: {
        id: body.userId,
        tableName: 'AD_User'
      }
    }
  }
  if(body.rAvsAddrId) {
    newObjValue = {...newObjValue, 
      R_AvsAddr: {
        id: body.rAvsAddrId
      }
    }
  }
  if(body.bankAccountTypeId) {
    newObjValue = {...newObjValue, 
      BankAccountType: {
        id: body.bankAccountTypeId
      }
    }
  }
  if(body.bpBankAcctUseId) {
    newObjValue = {...newObjValue, 
      BPBankAcctUse: {
        id: body.bpBankAcctUseId
      }
    }
  }
  if(body.creditCardTypeId) {
    newObjValue = {...newObjValue, 
      CreditCardType: {
        id: body.creditCardTypeId
      }
    }
  }
  if(body.routingNo) { newObjValue = {...newObjValue, routingNo: body.routingNo} }
  if(body.iban) { newObjValue = {...newObjValue, IBAN: body.iban} }

  if(body.partnerId && body.accountName) {
    const res: any = await fetchHelper(event, 'models/c_bp_bankaccount', 'POST', token, {
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      },
      isActive: body.isActive,
      isACH: body.isACH,
      accountNo: body.accountNo,
      A_Name: body.accountName,
      A_EMail: body.accountEmail,
      A_City: body.accountCity,
      A_State: body.accountState,
      A_Street: body.accountStreet,
      A_Zip: body.accountZip,
      A_Ident_DL: body.accountIdentDL,
      A_Ident_SSN: body.accountIdentSSN,
      A_Country: body.accountCountry,
      creditCardExpMM: body.creditCardExpMM,
      creditCardExpYY: body.creditCardExpYY,
      creditCardVV: body.creditCardVV,
      creditCardNumber: body.creditCardNumber,
      C_BPartner_ID: {
        id: body.partnerId,
        tableName: 'C_BPartner'
      },
      ...newObjValue,
      tableName: 'c_bp_bankaccount'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = {
        status: error.status || error.statusCode || 500,
        message: error.detail || error.message || error.statusMessage
      }
      //if(data.status < 500) {
        //@ts-ignore
        //setCookie(event, 'user', null)
      //}
    }
  }

  return data
})